//=============================================================================
// MAR_Utilities.js
//=============================================================================

var Imported = Imported || {};
Imported.MAR_Utilities = true;

var MAR = MAR || {};
MAR.Utilities = MAR.Utilities || {};

/*:
 * @plugindesc ユーティリティ クラス群
 * 
 * @help
 * ちょっとしたスクリプトを纏めています。
 */

// 時間帯でのあいさつ
MAR.Utilities.Window_Message_convertEscapeCharacters = Window_Message.prototype.convertEscapeCharacters;
Window_Message.prototype.convertEscapeCharacters = function (text)
{
    var timeZone;
    var type = $gameVariables.value(5);

    switch ($gameVariables.value(82))
    {
        case 0:
            if (type == 0)
            {
                timeZone = "안녕하세요";
            }
            else if (type == 1)
            {
                timeZone = "안녕";
            }
            break;

        case 1:
        case 2:
            timeZone = "안녕하세요";
            break;

        case 3:
            timeZone = "안녕하세요";
            break;
    }
    $gameVariables.setValue(5, 0);

    text = MAR.Utilities.Window_Message_convertEscapeCharacters.call(this, text);
    text = text.replace(/\x1bTZ/gi, timeZone);
    return text;
};

// セーブ コマンドのオンオフ
MAR.Utilities.Window_MenuCommand_needsCommand = Window_MenuCommand.prototype.needsCommand;
Window_MenuCommand.prototype.needsCommand = function (name)
{
    var flags = $dataSystem.menuCommands;
    if (flags)
    {
        switch (name)
        {
            case 'item':
                return flags[0];
            case 'skill':
                return flags[1];
            case 'equip':
                return flags[2];
            case 'status':
                return flags[3];
            case 'formation':
                return flags[4];
            case 'save':
                return flags[5] && !$gameSwitches.value(4) && !$gameSwitches.value(14);
            case 'move':
                return !$gameSwitches.value(14);
        }
    }
    return true;
};

// エンディング
MAR.Utilities.Scene_Save_onSaveSuccess = Scene_Save.prototype.onSaveSuccess;
Scene_Save.prototype.onSaveSuccess = function ()
{
    MAR.Utilities.Scene_Save_onSaveSuccess.call(this);

    $gameSwitches.setValue(19, false);
};

MAR.Utilities.Scene_File_onSavefileCancel = Scene_File.prototype.onSavefileCancel;
Scene_File.prototype.onSavefileCancel = function ()
{
    MAR.Utilities.Scene_Save_onSaveSuccess.call(this);

    $gameSwitches.setValue(19, false);
};

// 初期化処理
Game_Player.prototype.Initialize = function ()
{
    // 初期レシピ
    for (var i = 143; i < 149; ++i)
    {
        $gameParty.gainItem($dataItems[i], 1, false);
    }

    // 素材情報
    for (var i = 49; i < 67; ++i)
    {
        $gameParty.gainItem($dataItems[i], 1, false);
    }

    // 生成アイテム
    for (var i = 213; i < 219; ++i)
    {
        $gameParty.gainItem($dataItems[i], 1, false);
    }
};

// 初期化処理
Game_Player.prototype.checkRecipe = function ()
{
    // 194-157

    for (var i = 149, j = 219; i < 157; ++i, ++j)
    {
        if ($gameParty.hasItem($dataItems[i]) && !$gameParty.hasItem($dataItems[j]))
        {
            $gameParty.gainItem($dataItems[j], 1, false);
        }
    }

    if ($gameParty.hasItem($dataItems[197]) && !$gameParty.hasItem($dataItems[227]))
    {
        $gameParty.gainItem($dataItems[227], 1, false);
    }

    if ($gameParty.hasItem($dataItems[198]) && !$gameParty.hasItem($dataItems[228]))
    {
        $gameParty.gainItem($dataItems[228], 1, false);
    }
};

// 処女非処女処理
Game_Player.prototype.setNotVirgin = function ()
{
    $gameSwitches.setValue(10, true);

    $gameActors.actor(1).setNickname("비처녀");
};

// 全滅処理
Scene_Base.prototype.checkGameover = function ()
{
    if ($gameParty.isAllDead())
    {
        switch ($gameVariables.value(49))
        {
            case 27:
                $gameSwitches.setValue(18, true);

                $gameSwitches.setValue(17, true);
                break;

            case 28:
                $gameSwitches.setValue(16, true);

                $gameSwitches.setValue(17, true);
                break;

            default:
                $gameSwitches.setValue(9, true);
                break;
        }
    }
};

// MH 確率
Game_Player.prototype.setMHRandomValue = function ()
{
    // 1/64
    if (Math.random() < 0.015625)
    {
        $gameVariables.setValue(1, 1);
    }
    else
    {
        $gameVariables.setValue(1, 0);
    }
};

// 借金確認
Game_Player.prototype.checkMoney = function ()
{
    // 1/64
    if (Math.random() < 0.015625)
    {
        $gameVariables.setValue(1, 1);
    }
    else
    {
        $gameVariables.setValue(1, 0);
    }
};

// 中級錬金術師チェック
Game_Player.prototype.checkMiddleAlchemy = function ()
{
    var quests;

    quests = [320, 390, 410, 400, 340, 420, 370];

    $gameSwitches.setValue(6, false);
    for (var i = 0; i < 10; ++i)
    {
        for (var j = 0; j < quests.length; ++j)
        {
            if ($gameVariables.value(101 + i) == quests[j])
            {
                return;
            }
        }
    }
    $gameSwitches.setValue(6, true);
};

// 兄イベント発生
Game_Player.prototype.setBrotherEvent = function ()
{
    var timeZone = $gameVariables.value(82);
    var day = $gameVariables.value(84);

    var count = $gameVariables.value(86);

    $gameSwitches.setValue(6, false);

    if ($gameSwitches.value(15))
    {
        return;
    }

    if ($gameVariables.value(110) != -1)
    {
        return;
    }

    if (day >= 30)
    {
        return;
    }

    switch (count)
    {
        case 0:
            // 5日目以降なら何時でも
            if (day >= 5)
            {
                $gameSwitches.setValue(6, true);
            }
            break;

        case 1:
            if (day >= 10)
            {
                $gameSwitches.setValue(6, true);
            }
            break;

        case 2:
            if (day >= 15)
            {
                $gameSwitches.setValue(6, true);
            }
            break;

        case 3:
            if (day >= 20)
            {
                $gameSwitches.setValue(6, true);
            }
            break;

        case 4:
            if (day >= 25)
            {
                $gameSwitches.setValue(6, true);
            }
            break;
    }
};


// 確率からランダムな値を設定
Game_Player.prototype.setRandomValue = function (rates, rateTotal)
{
    if (rateTotal == null)
    {
        rateTotal = 100;
    }

    var randomValue = Math.random() * rateTotal;

    $gameVariables.setValue(1, 0);
    for (var i = 0; i < rates.length; ++i)
    {
        if (randomValue <= rates[i])
        {
            $gameVariables.setValue(1, i);
            break;
        }
        else
        {
            randomValue -= rates[i];
        }
    }
};

// アイテム並び替え
Game_Party.prototype.items = function ()
{
    var list = [];
    for (var id in this._items)
    {
        list.push($dataItems[id]);
    }

    list.sort(function (lhs, rhs)
    {
        var aID, bID;

        if (!!lhs.meta.id)
        {
            aID = parseInt(lhs.meta.id);
        }
        else
        {
            aID = lhs.id;
        }

        if (!!rhs.meta.id)
        {
            bID = parseInt(rhs.meta.id);
        }
        else
        {
            bID = rhs.id;
        }

        if (aID < bID)
        {
            return -1;
        }
        if (aID > bID)
        {
            return 1;
        }
        return 0;
    });

    return list;
};

AudioManager.playBgmAtName = function (name, pos)
{
    bgm = {
        "name": name,
        "pan": 0,
        "pitch": 100,
        "volume": 90
    };

    AudioManager.playBgm(bgm, pos);
};

Game_Player.prototype.playBGMAtMapID = function (newMapId)
{
    var bgm;

    if ($gameSwitches.value(19))
    {
        AudioManager.stopBgm();
        return;
    }

    if ($gameVariables.value(82) < 3)
    {
        bgm = {
            "name": "bgm_normal01",
            "pan": 0,
            "pitch": 100,
            "volume": 90
        };
    }
    else
    {
        bgm = {
            "name": "bgm_normal03",
            "pan": 0,
            "pitch": 100,
            "volume": 90
        };
    }

    switch (newMapId)
    {
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
        case 15:
        case 16:
        case 17:
        case 18:
            AudioManager.playBgm(bgm);
            break;
    }
}

Scene_Map.prototype.setDayPicture = function (newMapId)
{
    switch (newMapId)
    {
        case 7:
        case 19:

            var name;
            var blendMode;
            switch ($gameVariables.value(82))
            {
                case 0:
                    name = "朝";
                    blendMode = 2;
                    break;

                case 1:
                    name = "昼";
                    blendMode = 3;
                    break;

                case 2:
                    name = "夕";
                    blendMode = 2;
                    break;

                case 3:
                    name = "夜";
                    blendMode = 2;
                    break;
            }
            $gameScreen.showPicture(1, name, 0, 0, 0, 100, 100, 255, blendMode)
            break;

        default:
            $gameScreen.erasePicture(1);
            break;
    }
};

Scene_Map.prototype.fadeInForTransfer = function ()
{
    var fadeType = $gamePlayer.fadeType();

    if (SceneManager.isPreviousScene(Scene_Title) || SceneManager.isPreviousScene(Scene_Load))
    {
        fadeType = 999;
    }

    this.setDayPicture($gameMap.mapId());
    $gamePlayer.playBGMAtMapID($gameMap.mapId());
    switch (fadeType)
    {
        case 0:
        case 1:
            this.startFadeIn(this.fadeSpeed(), fadeType === 1);
            break;

        case 999:
            this.startFadeIn(this.slowFadeSpeed(), fadeType === 1);
            break;
    }
};

//-----------------------------------------------------------------------------
// Pair
//
// コンストラクタ
function Pair()
{
    this._first = null;
    this._second = null;
}

// プロパティ定義
Object.defineProperties(Pair.prototype,
{
    first: { get: function () { return this._first; }, set: function (value) { this._first = value; } },
    second: { get: function () { return this._second; }, set: function (value) { this._second = value; } },
});

// プラグイン コマンド
Game_System.prototype.shouldCommonQuestListRefresh = function ()
{
    if (this._shouldCommonQuestListRefresh == null)
    {
        this._shouldCommonQuestListRefresh = false;
    }

    return this._shouldCommonQuestListRefresh;
};

Game_System.prototype.SetShouldCommonQuestListRefresh = function (value)
{
    this._shouldCommonQuestListRefresh = value;
};

//-----------------------------------------------------------------------------
// QuestListWindow
//
// クエスト名の取得
function setQuestData(data, list)
{
    var title, client, detail, state, requireItemID, requireNumItems;
    var reward;

    for (var i = 0; i < list.length; ++i)
    {
        title = client = detail = state = "";
        reward = { message: "", money: -1 };

        switch (list[i])
        {
            case 10:
                title = "깊은 잠에 붙는 방법";

                client = "바에있는 남자";

                detail = "잠들기가 나빠서 곤란 해하고 있어요.\n";
                detail += "\\c[17]수면 버섯 \\c[0]및\\c[17]깨끗한 물\\c[0]에서、\n";
                detail += "\\c[4]수면약\\c[0]을 만들고 싶어요.";

                reward.message = "1,000,000G";
                reward.money = 1000000;

                requireItemID = 200;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[200]) > 0)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                state = "주문 중";
                break;

            case 20:
                title = "남성의 고민";

                client = "여관 앞에있는 초로의 노인";

                detail = "발기 부전으로 고생하고 있잖아.\n";
                detail += "\\c[17]화염초 \\c[0]및\\c[17]미노타우로스의 살\\c[0]、\n";
                detail += "\\c[17]활력제\\c[0]에서\\c[4]발기약\\c[0]을\n";
                detail += "만들어줬으면 해요.";

                reward.message = "1,000,000G";
                reward.money = 1000000;

                requireItemID = 201;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[201]) > 0)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                state = "주문 중";
                break;

            case 30:
                title = "그대는 음란 한 고기 변기";

                client = "여관 2F에있는 수수께끼의 남자";

                detail = "하나 일을 부탁하고 싶다.\n";
                detail += "\\c[17]수면 버섯 \\c[0]및\\c[17]빙초\\c[0]、\n";
                detail += "\\c[17]슬라임젤리\\c[0]에서、\n";
                detail += "\\c[4]최면약\\c[0]을만들어주지 않을까.";

                reward.message = "1,000,000G";
                reward.money = 1000000;

                requireItemID = 204;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[204]) > 0)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                state = "주문 중";
                break;

            case 40:
                title = "섹스 도핑";

                client = "집 옆에있는 하인";

                detail = "섹스에 자신이 없어서...\n";
                detail += "\\c[17]만드라고라\\c[0]및\\c[17]금의 달걀\\c[0]、\n";
                detail += "\\c[17]마법의 물\\c[0]에서、\n";
                detail += "\\c[4]미약\\c[0]을 만들어 주었으면 해. ";

                reward.message = "1,000,000G";
                reward.money = 1000000;

                requireItemID = 205;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[205]) > 0)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                state = "주문 중";
                break;

            case 50:
                title = "숲 광수";

                client = "건강 지향의 남자";

                detail = "우물물 다니 마실 수 없어.\n";
                detail += "숲속에 솟는 물을 갖고 싶다.\n";
                detail += "\\c[4]깨끗한 물\\c[0]을\\c[17]5개\\c[0]\n";
                detail += "구해주지 않을까.";

                reward.message = "50,000G";
                reward.money = 50000;

                requireItemID = 101;
                requireNumItems = 5;

                if ($gameParty.numItems($dataItems[101]) >= 5)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 60:
                title = "엘로슬라임";

                client = "괴물 박사";

                detail = "\\c[17]테크라 산도\\c[0]에서\\c[4]노란색 슬라임\\c[0]을\n";
                detail += "보인 거 아냐 해요.\n";
                detail += "연구하고 싶기 때문에 토벌 해\n";
                detail += "달라고 않습니까 네요.";

                reward.message = "120,000G";
                reward.money = 120000;

                if ($gameSwitches.value(201))
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 70:
                title = "궁극의 고기 요리";

                client = "음식 기자";

                detail = "\\c[4]미노타우로스의 살\\c[0]을\n";
                detail += "사용한 고기 요리를 만들고 싶다.\n";
                detail += "\\c[17]1개\\c[0]에서좋은 제공되면\n";
                detail += "꼭 나에게 양보 해주지 않을까.";

                reward.message = "80,000G";
                reward.money = 80000;

                requireItemID = 112;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[112]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 80:
                title = "지고의 계란 요리";

                client = "요리 연구가";

                detail = "계란 요리로 손님을 대접하고 싶다.\n";
                detail += "드문\\c[4]금의 달걀\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 해주지 않는 것일까.\n";
                detail += "보수는 넉넉하게 낸다.";

                reward.message = "150,000G";
                reward.money = 150000;

                requireItemID = 118;
                requireNumItems = 5;

                if ($gameParty.numItems($dataItems[118]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 90:
                title = "벽난로에 불을";

                client = "추위를 많이 타는 노인";

                detail = "최근 추워 왔기 때문의.\n";
                detail += "벽난로에서 점화 장작 원하는 거 아냐.\n";
                detail += "\\c[4]보통 가지\\c[0]을\\c[17]5개\\c[0]\n";
                detail += "납품 해주고 않습니까 네요.\n";

                reward.message = "40,000G";
                reward.money = 40000;

                requireItemID = 90;
                requireNumItems = 5;

                if ($gameParty.numItems($dataItems[106]) >= 5)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 100:
                title = "소매를 올려라";

                client = "무서운 얼굴 표정의 대장장이";

                detail = "최근 행상인이 오지 않아\n";
                detail += "소재가 손에 들어 가지 않게 말이야.\n";
                detail += "\\c[4]동의 덩어리\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 해주지 않을까.\n";

                reward.message = "120,000G";
                reward.money = 120000;

                requireItemID = 119;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[119]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 110:
                title = "망치 소리를 울려 라";

                client = "무서운 얼굴 표정의 대장장이";

                detail = "최근 행상인이 오지 않아\n";
                detail += "소재가 손에 들어 가지 않게 말이야.\n";
                detail += "\\c[4]철의 덩어리\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 해주지 않을까.\n";

                reward.message = "150,000G";
                reward.money = 150000;

                requireItemID = 120;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[120]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 120:
                title = "불을 타야 마라";

                client = "무서운 얼굴 표정의 대장장이";

                detail = "최근 행상인이 오지 않아\n";
                detail += "소재가 손에 들어 가지 않게 말이야.\n";
                detail += "\\c[4]석탄\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 해주지 않을까.\n";

                reward.message = "150,000G";
                reward.money = 150000;

                requireItemID = 122;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[122]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 130:
                title = "인류의 꿈";

                client = "아이템 수집의 남자";

                detail = "\\c[4]인어의 눈물\\c[0]이 근처에서 잡히는 경우\n";
                detail += "물어 물어 보았다거야.\n";
                detail += "\\c[17]1개\\c[0]에서좋은 구해\n";
                detail += "으면 고가로 매입 있어요.\n";

                reward.message = "150,000G";
                reward.money = 150000;

                requireItemID = 123;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[123]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 140:
                title = "학문의 권유";

                client = "도시의 교사";

                detail = "아이들에게 공부를 가르쳐주세요.\n";
                detail += "\\c[4]양피지\\c[0]이\\c[17]1개\\c[0]필요한거야.\n";
                detail += "보수는 너무 지불하지 만,\n";
                detail += "준비 해주지 않는 것일까.\n";

                reward.message = "60,000G";
                reward.money = 60000;

                requireItemID = 124;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[124]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 150:
                title = "따뜻한니까";

                client = "장난 꾸러기 꼬마";

                detail = "최근 추워 왔기 때문\n";
                detail += "주머니에 넣어두고 싶은거야.\n";
                detail += "\\c[4]핫톤\\c[0]을\\c[17]1개\\c[0]그래요.\n";
                detail += "아니,하세요.";

                reward.message = "5,000G";
                reward.money = 5000;

                requireItemID = 121;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[121]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 160:
                title = "지옥의 소식도";

                client = "욕심 할아버지";

                detail = "금 · 금 · 금 잖아.\n";
                detail += "저승까지 가져갈 것이다.\n";
                detail += "\\c[4]금괴\\c[0]을\\c[17]1개\\c[0]안성맞춤.";

                reward.message = "350,000G";
                reward.money = 350000;

                requireItemID = 116;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[116]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 170:
                title = "자신에 대한 보상";

                client = "스위트 여자";

                detail = "꽃을 먹을라고 아주 좋은예요.\n";
                detail += "지금 그런 식용 꽃이 유행 중임.\n";
                detail += "\\c[4]프로스트플라워\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 잘 부탁해.";

                reward.message = "30,000G";
                reward.money = 30000;

                requireItemID = 142;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[142]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 180:
                title = "물고기 같은 눈";

                client = "지친 중년 남성";

                detail = "피로가 눈에왔다주세요.\n";
                detail += "그래서\\c[4]눈약 \\c[0]을\\c[17]1개\\c[0]\n";
                detail += "항상 휴대 해 두려고 생각한다.\n";
                detail += "납품 해주지 않겠습니까.\n";

                reward.message = "40,000G";
                reward.money = 40000;

                requireItemID = 209;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[209]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 190:
                title = "올해 유행 조짐";

                client = "연한이 들어간 주부";

                detail = "감기가 유행 할 것 같은.\n";
                detail += "그래서 미리\\c[4]감기약\\c[0]을\n";
                detail += "상비하고 싶으니까,\\c[17]3개\\c[0]\n";
                detail += "납품 해주지 않는 것일까.";

                reward.message = "120,000G";
                reward.money = 120000;

                requireItemID = 208;
                requireNumItems = 3;

                if ($gameParty.numItems($dataItems[208]) >= 3)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 200:
                title = "영원한 불꽃";

                client = "보석의 남편";

                detail = "다이아몬드는 가공해야만합니다.\n";
                detail += "보석으로 판매 싶어서\n";
                detail += "\\c[4]금강석\\c[0]을\\c[17]1개\\c[0]납품 희망합니다.";

                reward.message = "300,000G";
                reward.money = 300000;

                requireItemID = 117;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[117]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 210:
                title = "레드슬라임";

                client = "괴물 박사";

                detail = "아주 뜨겁다\\c[17]불꽃의 샛길\\c[0]에서\n";
                detail += "\\c[4]빨간색 슬라임\\c[0]을본 거 아냐 해요.\n";
                detail += "연구하고 싶기 때문에 토벌\n";
                detail += "와줘서 않습니까 네요.";

                reward.message = "120,000G";
                reward.money = 120000;

                if ($gameSwitches.value(202))
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 220:
                title = "그린슬라임";

                client = "괴물 박사";

                detail = "먼 거 아냐하지만\\c[17]바르토크 설원\\c[0]에서\n";
                detail += "\\c[4]녹색 슬라임\\c[0]을본 거 아냐 해요.\n";
                detail += "연구하고 싶기 때문에 토벌\n";
                detail += "와줘서 않습니까 네요.";

                reward.message = "150,000G";
                reward.money = 150000;

                if ($gameSwitches.value(203))
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 230:
                title = "오빠의 의뢰 그 1";

                client = "오빠";

                detail = "사실 別口에도 부채가 있었어.\n";
                detail += "\\c[17]밤\\c[0]이되면\\c[4]고물상의 전\\c[0]에\n";
                detail += "가주고...\n"
                detail += "상대 남자가 기다리고 있으니...\n";

                reward.message = "오빠의 빚 갚아";
                reward.money = 0;

                state = "주문 중";
                break;

            case 240:
                title = "오빠의 의뢰 그 2";

                client = "오빠";

                detail = "이번에는\\c[4]여관 앞에\\c[0]이다.\n";
                detail += "이야기는 붙어있는 때문,\n";
                detail += "\\c[17]밤\\c[0]이되면가주고...\n";

                reward.message = "오빠의 빚 갚아";
                reward.money = 0;

                state = "주문 중";
                break;

            case 250:
                title = "오빠의 의뢰 그 3";

                client = "오빠";

                detail = "...다음은\\c[4]무기점 앞에서\\c[0]이다... \n";
                detail += "\\c[17]밤\\c[0]이되면가주고...\n";
                detail += "예처럼 이야기 다니고 있으니\n";
                detail += "부탁한다.\n";

                reward.message = "오빠의 빚 갚아";
                reward.money = 0;

                state = "주문 중";
                break;

            case 260:
                title = "오빠의 의뢰 그 4";

                client = "오빠";

                detail = "\\c[4]술집의 북쪽에 오두막\\c[0]이있을?\n";
                detail += "이번에는 저기이다.\n";
                detail += "시간은 언제라도 좋다고이다.\n";
                detail += "잘해 주며,부탁한다.\n";

                reward.message = "오빠의 빚 갚아";
                reward.money = 0;

                state = "주문 중";
                break;

            case 270:
                title = "오빠의 의뢰 그 5";

                client = "오빠";

                detail = "\\c[4]북쪽에있는 큰 저택\\c[0]、\n";
                detail += "알 잖아...\n";
                detail += "예처럼 이야기는 붙고 있으니\n";
                detail += "\\c[17]밤\\c[0]이되면가 줘!\n";

                reward.message = "오빠의 빚 갚아";
                reward.money = 0;

                state = "주문 중";
                break;

            case 280:
                title = "반한 것이 패배";

                client = "사랑을 한 남성";

                detail = "그녀가 아무래도 이것이\n";
                detail += "갖고 싶다고 말하는거야.\n";
                detail += "\\c[4]네잎 클로버\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 해주고 묻는다.\n";

                reward.message = "77,777G";
                reward.money = 77777;

                requireItemID = 128;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[128]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 290:
                title = "원초적 본능";

                client = "도시의 대표";

                detail = "벽난로 앞에서 차가운 음료를 마신다.\n";
                detail += "그런 사치를하고 싶어주세요.\n";
                detail += "\\c[4]얼음의 결정\\c[0]을\\c[17]3개\\c[0]\n";
                detail += "전해주게.\n";

                reward.message = "30,000G";
                reward.money = 30000;

                requireItemID = 138;
                requireNumItems = 3;

                if ($gameParty.numItems($dataItems[138]) >= 3)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 300:
                title = "키레이 키레이";

                client = "깨끗 좋아하는 여자";

                detail = "재에서 비누를 만들 것 같다거야.\n";
                detail += "그런 일 묻자군요?\n";
                detail += "\\c[4]몬스터의 재\\c[0]을\\c[17]5개\\c[0]\n";
                detail += "전해 줘.\n";

                reward.message = "25,000G";
                reward.money = 25000;

                requireItemID = 137;
                requireNumItems = 5;

                if ($gameParty.numItems($dataItems[137]) >= 5)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;


            case 310:
                title = "동장군";

                client = "오래된 집에 사는 남자";

                detail = "본격적으로 겨울이 온다.\n";
                detail += "집 수리에\\c[4]철의 못\\c[0]이\n";
                detail += "\\c[17]3개\\c[0]필요한거야.\n";
                detail += "시급히 마련 해준.\n";

                reward.message = "50,000G";
                reward.money = 50000;

                requireItemID = 131;
                requireNumItems = 3;

                if ($gameParty.numItems($dataItems[131]) >= 3)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 320:
                title = "주부 화병";

                client = "연한이 들어간 주부";

                detail = "항아리를 아이가 나누어 버렸어.\n";
                detail += "이제 겨울이 오는데...\n";
                detail += "그래서\\c[4]큰 항아리\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "준비 해줘.\n";

                reward.message = "45,000G";
                reward.money = 45000;

                requireItemID = 129;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[129]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 330:
                title = "어떤 관문 소문";

                client = "수완 행상인";

                detail = "아무래도 바르톡 관문에서\n";
                detail += "산사태가 일어난 것 같다.\n";
                detail += "장사의 기회라고 생각이다.\n";
                detail += "\\c[4]곡괭이 \\c[0]을\\c[17]3개\\c[0]준비 해줘.\n";

                reward.message = "60,000G";
                reward.money = 60000;

                requireItemID = 130;
                requireNumItems = 3;

                if ($gameParty.numItems($dataItems[130]) >= 3)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 340:
                title = "생활의 끈";

                client = "연한이 들어간 주부";

                detail = "연말의 대청소가 다가 왔어요.\n";
                detail += "올해는 일찍 준비해 두는거야.\n";
                detail += "그래서\\c[4]튼튼한 줄\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "준비 해줘.\n";

                reward.message = "40,000G";
                reward.money = 40000;

                requireItemID = 134;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[134]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 350:
                title = "통통통";

                client = "수완 행상인";

                detail = "여기에서 물건을 구입하고,\n";
                detail += "여행에 나올까 생각주세요.\n";
                detail += "\\c[4]큰 통\\c[0]을\\c[17]3개\\c[0]\n";
                detail += "준비 주면 매입 있어요.\n";

                reward.message = "60,000G";
                reward.money = 60000;

                requireItemID = 135;
                requireNumItems = 3;

                if ($gameParty.numItems($dataItems[135]) >= 3)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 360:
                title = "최고의 소재";

                client = "무서운 얼굴 표정의 대장장이";

                detail = "대장장이 일을하고 있다면 누구든지\n";
                detail += "이것을 두드려 싶은 것이다.\n";
                detail += "\\c[4]크리스털\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 해주지 않을까.\n";

                reward.message = "200,000G";
                reward.money = 200000;

                requireItemID = 141;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[141]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 370:
                title = "엄선 된 토핑";

                client = "스위트 여자";

                detail = "스위트 토핑으로\n";
                detail += "젬을 만들려고 생각.\n";
                detail += "그래서\\c[4]레드베리\\c[0]을\\c[17]5개\\c[0]\n";
                detail += "준비했으면 좋겠다 것.";

                reward.message = "30,000G";
                reward.money = 30000;

                requireItemID = 136;
                requireNumItems = 5;

                if ($gameParty.numItems($dataItems[136]) >= 5)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 380:
                title = "저주의 아이템";

                client = "마술에 빠졌다 여자";

                detail = "의식이 필요.\n";
                detail += "\\c[4]암의 코인\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "저주 않으려면\n";
                detail += "가져 오라...\n";

                reward.message = "66,666G";
                reward.money = 66666;

                requireItemID = 140;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[140]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 390:
                title = "나무 일으켜";

                client = "씩씩한 청년";

                detail = "집 앞의 나무를 이동 이는거이다.\n";
                detail += "그 때문에\\c[4]곡괭이 \\c[0]이\\c[17]1개\\c[0]\n";
                detail += "필요할주세요.\n";
                detail += "꼭 물어 볼게요.\n";

                reward.message = "35,000G";
                reward.money = 35000;

                requireItemID = 130;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[130]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 400:
                title = "도시의 불빛";

                client = "경비병";

                detail = "등유를 추가하려고 했습니다만,\n";
                detail += "재고가없는 것 같습니다.\n";
                detail += "\\c[4]식물유\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품받을 수있을 것입니다.\n";

                reward.message = "35,000G";
                reward.money = 35000;

                requireItemID = 133;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[133]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 410:
                title = "장롱 수리";

                client = "일요일 목수를하는 남성";

                detail = "장롱 망가져 부분을\n";
                detail += "조금 고치고 싶어서 네요.\n";
                detail += "\\c[4]철의 못\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품 해 줄 수 없을까.\n";

                reward.message = "30,000G";
                reward.money = 30000;

                requireItemID = 131;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[131]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;

            case 420:
                title = "술 저장고";

                client = "바의 주인";

                detail = "와인을 저장하는 탈이\n";
                detail += "시급하게 했죠.\n";
                detail += "\\c[4]큰 통\\c[0]을\\c[17]1개\\c[0]\n";
                detail += "납품하십시오.\n";

                reward.message = "45,000G";
                reward.money = 45000;

                requireItemID = 135;
                requireNumItems = 1;

                if ($gameParty.numItems($dataItems[135]) >= 1)
                {
                    state = "보고 가능";
                }
                else
                {
                    state = "주문 중";
                }
                break;
        }

        if (list[i] != -1)
        {
            data.push({ no: list[i], title: title, client: client, detail: detail, reward: reward, state: state, requireItemID: requireItemID, requireNumItems: requireNumItems });
        }
    }
};

// コンストラクタ
function QuestListWindow(list, isCommon)
{
    this.initialize.apply(this, arguments);
}

QuestListWindow.prototype = Object.create(Window_Command.prototype);
QuestListWindow.prototype.constructor = QuestListWindow;

// プロパティ定義
Object.defineProperties(QuestListWindow.prototype,
{
    data: { get: function () { return this._data; } },
    contentWindow: { get: function () { return this._contentWindow; }, set: function (value) { this._contentWindow = value; } },
    canPlayOK: { get: function () { return this._canPlayOK; }, set: function (value) { this._canPlayOK = value; } },
    isCommon: { get: function () { return this._isCommon; } },
});

// 初期化
QuestListWindow.prototype.initialize = function (list, isCommon)
{
    var x = 20;
    var y = 35;

    this._data = [];
    setQuestData(this._data, list);

    this._isCommon = isCommon;

    Window_Command.prototype.initialize.call(this, x, y);

    this._contentWindow = null;
    this._canPlayOK = false;
};

// 幅
QuestListWindow.prototype.windowWidth = function ()
{
    return 300;
};

// 決定音
QuestListWindow.prototype.playOkSound = function ()
{
    if (this._canPlayOK)
    {
        SoundManager.playOk();
    }
};

// コマンドの設定
QuestListWindow.prototype.makeCommandList = function ()
{
    for (var i = 0; i < this._data.length; ++i)
    {
        this.addCommand(this._data[i].title, 'quest_' + this._data[i].no, true);
    }

    if (this._data.length == 0)
    {
        this.addCommand("", "nullpo", true);
    }
};

// 水平線
QuestListWindow.prototype.drawHorzLine = function (y)
{
    var lineY = y + this.lineHeight() / 2 - 1;
    this.contents.paintOpacity = 48;
    this.contents.fillRect(0, lineY, this.contentsWidth(), 2, this.normalColor());
    this.contents.paintOpacity = 255;
};

QuestListWindow.prototype.windowHeight = function ()
{
    return 60 + this.fittingHeight(this.numVisibleRows());
};

QuestListWindow.prototype.itemRect = function (index)
{
    var rect = new Rectangle();
    var maxCols = this.maxCols();
    rect.width = this.itemWidth();
    rect.height = this.itemHeight();
    rect.x = index % maxCols * (rect.width + this.spacing()) - this._scrollX;
    rect.y = Math.floor(index / maxCols) * rect.height - this._scrollY;

    rect.y += 60;
    return rect;
};

// 全てのアイテムを描画
QuestListWindow.prototype.drawAllItems = function ()
{
    var lineHeight = 36;

    this.changeTextColor(this.normalColor());
    this.drawText("퀘스트 명", 0, 0, this._width - (this.standardPadding() * 2), 'center');

    this.drawHorzLine(24);

    var topIndex = this.topIndex();
    for (var i = 0; i < this.maxPageItems() ; i++)
    {
        var index = topIndex + i;
        if (index < this.maxItems())
        {
            this.drawItem(index);
        }
    }
};

// 更新
QuestListWindow.prototype.update = function ()
{
    var oldIndex = this._index;

    Window_Selectable.prototype.update.call(this);

    if (this._isCommon)
    {
        if ($gameSystem.shouldCommonQuestListRefresh())
        {
            this.refresh();
            this._contentWindow.refresh();
        }

        if (oldIndex != this._index)
        {
            this._contentWindow.refresh();
        }
    }
    else
    {
        if (oldIndex != this._index)
        {
            this._contentWindow.refresh();
        }
    }
};

//-----------------------------------------------------------------------------
// QuestContentWindow
//
// コンストラクタ
function QuestContentWindow(listWindow)
{
    this._listWindow = listWindow;

    this.initialize.apply(this, arguments);
}

QuestContentWindow.prototype = Object.create(Window_Base.prototype);
QuestContentWindow.prototype.constructor = QuestContentWindow;

// プロパティ定義
Object.defineProperties(QuestContentWindow.prototype,
{
    listWindow: { get: function () { return this._listWindow; }, set: function (value) { this._listWindow = value; } },
});

// 初期化
QuestContentWindow.prototype.initialize = function ()
{
    var x = 320;
    var y = this._listWindow.y;

    var width = 480;
    var height;
    if (this._listWindow.isCommon)
    {
        height = 464;
    }
    else
    {
        height = 560;
    }
    Window_Base.prototype.initialize.call(this, x, y, width, height);

    this.refresh();
};

// 行の高さ
QuestContentWindow.prototype.lineHeight = function ()
{
    return this._lineHeight || 36;
};

// リフレッシュ
QuestContentWindow.prototype.refresh = function ()
{
    this.contents.clear();

    var data = this._listWindow.data[this._listWindow.index()]; 

    if (!data)
    {
        return;
    }

    var x = 20;
    var y = 0;

    var lineHeight = this.lineHeight();
    var halfLineHeight = lineHeight / 2;

    var titleColor = 3;

    this.changeTextColor(this.normalColor());
    this.drawText("퀘스트 내용", 0, y, this._width - (this.standardPadding() * 2), 'center');

    this.drawHorzLine(24);

    y += 24 + lineHeight;

    this.changeTextColor(this.textColor(titleColor));
    this.drawText("의뢰인：", x, y, this._width, 'left');

    this.changeTextColor(this.normalColor());

    y += lineHeight;
    this.drawText(data.client, x + 10, y, this._width, 'left');

    this.changeTextColor(this.textColor(titleColor));

    y += lineHeight + halfLineHeight;
    this.drawText("의뢰 내용：", x, y, this._width, 'left');

    this.changeTextColor(this.normalColor());

    y += lineHeight;
    this.drawTextEx(data.detail, x + 10, y, this._width, 'left');

    this.changeTextColor(this.textColor(titleColor));

    y += 108 + lineHeight + halfLineHeight;
    this.drawText("성공 보수：", x, y, this._width, 'left');

    this.changeTextColor(this.normalColor());

    y += lineHeight;
    this.drawTextEx(data.reward.message, x + 10, y, this._width, 'left');

    if (!this._listWindow.isCommon)
    {
        this.changeTextColor(this.textColor(titleColor));

        y += lineHeight + halfLineHeight;
        this.drawText("퀘스트 상황：", x, y, this._width, 'left');

        this.changeTextColor(this.normalColor());

        y += lineHeight;
        this.drawTextEx(data.state, x + 10, y, this._width, 'left');
    }
};

// 水平線
QuestContentWindow.prototype.drawHorzLine = function (y)
{
    var lineY = y + this.lineHeight() / 2 - 1;
    this.contents.paintOpacity = 48;
    this.contents.fillRect(0, lineY, this.contentsWidth(), 2, this.normalColor());
    this.contents.paintOpacity = 255;
};
